%%%%%%%%%********* Do not* change anything in this file **********%%%%%%%%%
function [J_cs] =bat_cs_J(y_in)
%% define Jacobian matrix for Ce
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Crank-Nicolson 
% F(block1)=((dt/2)*A_cs-1)cs(t+1)+(dt/2)f_cs(cs(t+1))+{((dt/2)*A_cs+1)cs(t)+(dt/2)f_cs(cs(t))}
% F(block2)=((dt/2)*A_ce-1)ce(t+1)+(dt/2)f_ce(cs(t+1))+{((dt/2)*A_ce+1)ce(t)+(dt/2)f_ce(ce(t))}
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load beta.mat
global eta conc concS_surf tem sv n_n n_s n_t n_p dt ...
       FARADAY RU diffuSolid_n diffuSolid_p R_s alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p A_csp A_csn A_cs jli stoic_p 
yL = 0.442; yH = 0.936; alf = 1.0/(yL-yH); bet = -yH/(yL-yH);
N_np=n_n+n_p;
T=tem(1);
nr=11;
dr=R_s/(nr-1);
conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
%% define BV equation
jli=zeros(n_t,1);
Jli_cs_e=zeros(n_t,1);
for k=1:n_n
    i0=kcon_n*(conc(k)^alpha_a)*((concS_max_n-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    e_a = alpha_a * FARADAY / ( RU * T );
    e_c = alpha_c * FARADAY / ( RU * T );
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    jli(k)=sv(k)*i0*(exp1-exp2);
    theta(k)=concS_surf(k)/concS_max_n;
    deriv_eta(k) = -(5.0647-12.578*0.5*theta(k)^(-0.5)-8.6322e-4*(-1)*theta(k)^(-2)+2.1765e-5*1.5*theta(k)^(0.5)...
                    -0.46016*exp(15*(0.06-theta(k)))*(-15)-0.55364*exp(-2.4326*(theta(k)-0.92))*(-2.4326))/concS_max_n;
    Jli_cs_e1(k)=(-alpha_a/(concS_max_n-concS_surf(k))+alpha_c/concS_surf(k))*jli(k);
    Jli_cs_e2(k) = sv(k)*i0*(exp1*e_a*deriv_eta(k)-exp2*(-e_c)*deriv_eta(k));
    Jli_cs_e(k)= Jli_cs_e1(k)+Jli_cs_e2(k);
end
for k=n_n+n_s+1:n_n+n_p+n_s
    i0=kcon_p*(conc(k)^alpha_a)*((concS_max_p-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    e_a = alpha_a * FARADAY / ( RU * T );
    e_c = alpha_c * FARADAY / ( RU * T );
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    jli(k)=sv(k)*i0*(exp1-exp2);
    theta(k)=alf*concS_surf(k)/concS_max_p+bet;
    deriv_eta(k)=-(7*p(1)*theta(k)^6+6*p(2)*theta(k)^5+5*p(3)*theta(k)^4+4*p(4)*theta(k)^3+...
       3*p(5)*theta(k)^2+2*p(6)*theta(k)+p(7)+p(8)*exp(p(9)*theta(k)^10)*p(9)*10*theta(k)^9)*alf/concS_max_p;
%  theta(k)=concS_surf(k)/concS_max_p;
%     deriv_eta(k)=-(6*85.681*theta(k)^5-357.7*5*theta(k)^4+4*613.89*theta(k)^3-555.65*3*theta(k)^2+281.06*2*theta(k)...
%         -76.648-0.30987*exp(5.657*theta(k)^115)*5.657*115*theta(k)^114)/concS_max_p;
% deriv_eta(k)=-(-6*49.0431*theta(k)^5+162.9822*5*theta(k)^4-4*215.7227*theta(k)^3+143.7466*3*theta(k)^2-...
%        49.4777*2*theta(k)+8.5978+620.9613*exp(1.9323e-4*theta(k)^30)*(1.9323e-4)*30*theta(k)^29)*alf/concS_max_p;
%     deriv_eta(k)=-((delta_eqpot(k)-eqpot(k))/delta_y(k));
    Jli_cs_e1(k)=(-alpha_a/(concS_max_p-concS_surf(k))+alpha_c/concS_surf(k))*jli(k);
    Jli_cs_e2(k) = sv(k)*i0*(exp1*e_a*deriv_eta(k)-exp2*(-e_c)*deriv_eta(k));
    Jli_cs_e(k)= Jli_cs_e1(k)+Jli_cs_e2(k);
%     Jli_cs_e(k)= Jli_cs_e1(k);
end 
%% define jacobian matrix for Concs
    %************************ define A_cs matrix ************************%
        i=1;
           %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
           A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
           A_csn(i,i+1)=2*diffuSolid_n/dr^2*dt;
           %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
           A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
           A_csp(i,i+1)=2*diffuSolid_p/dr^2*dt;
    
           for i=2:nr-1
                %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
                A_csn(i,i-1)=diffuSolid_n*(i-1)/(i)/dr^2*dt;
                A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
                A_csn(i,i+1)=diffuSolid_n*(i+1)/(i)/dr^2*dt;
                %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
                A_csp(i,i-1)=diffuSolid_p*(i-1)/(i)/dr^2*dt;
                A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
                A_csp(i,i+1)=diffuSolid_p*(i+1)/(i)/dr^2*dt;
            end
      i=nr;
                %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
                A_csn(i,i-1)=2*diffuSolid_n/dr^2*dt;
                A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
                %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
                A_csp(i,i-1)=2*diffuSolid_p/dr^2*dt;
                A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
   
    for j=1:n_n
        A_cs((j-1)*nr+1:j*nr,(j-1)*nr+1:j*nr)=A_csn;
    end

    for j=n_n+1:n_n+n_p
        A_cs((j-1)*nr+1:j*nr,(j-1)*nr+1:j*nr)=A_csp;
    end
%************************* define BV equation ***************************%
f_cs=zeros(nr*N_np,1);
for i=1:n_n   
    f_cs(i*nr)=-(2*(Jli_cs_e(i)/FARADAY/sv(i))*(1/R_s+1/dr))*dt;
end
for i=n_n+1:n_n+n_p
    f_cs(i*nr)=-(2*(Jli_cs_e(i+n_s)/FARADAY/sv(i+n_s))*(1/R_s+1/dr))*dt;
end
J_cs=(A_cs)+spdiags(f_cs,0,length(f_cs),length(f_cs));






